/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title RegisterCodeInfo
 * @author yanmaoyuan
 * @date 2021年2月25日
 * @version 1.0
 */
@Data
public class RegisterCodeInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 注册码
     */
    @JsonAlias("register_code")
    private String registerCode;

    /**
     * 推广包ID
     */
    @JsonAlias("template_id")
    private String templateId;

    /**
     * 仅当获取注册码指定该字段时才返回
     *
     * 安装应用时，扫码或者授权链接中带的state值。详见state说明
     */
    @JsonAlias("state")
    private String state;
}
