/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title PreAuthCode
 * @author yanmaoyuan
 * @date 2021年2月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class PreAuthCode extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 预授权码,最长为512字节
     */
    @JsonAlias("pre_auth_code")
    private String preAuthCode;

    /**
     * 有效期
     */
    @JsonAlias("expires_in")
    private Long expires;

}
