/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.provider;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * 该管理员在该提供商中能使用的应用列表，当登录用户为管理员时返回
 * 
 * @title Agent
 * @author yanmaoyuan
 * @date 2021年4月30日
 * @version 1.0
 */
@Data
public class Agent implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 应用id
     */
    @JsonAlias("agentid")
    private Integer agentId;

    /**
     * 该管理员对应用的权限：1.管理权限，0.使用权限
     */
    @JsonAlias("auth_type")
    private Integer authType;
}
