package cn.kinyun.wework.sdk.entity.oa;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author sunwen
 *
 * 审批流程信息，可能有多个审批节点。
 */
@Data
public class SpRecord implements Serializable {


    private static final long serialVersionUID = 6277844792822994648L;
    /**
     * 审批节点状态：1-审批中；2-已同意；3-已驳回；4-已转审；11-已退回
     */
    @JsonProperty("sp_status")
    private Integer spStatus;

    /**
     * 节点审批方式：1-或签；2-会签
     */
    @JsonProperty("approverattr")
    private Integer approverAttr;

    /**
     * 审批节点详情,一个审批节点有多个审批人
     */
    private List<Detail> details;
}
