package cn.kinyun.wework.sdk.entity.license.order;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
public class NewOrderJobResultResp extends ErrorCode {

    /**
     * 订单创建结果。
     * 1：创建完成
     * 2：创建中，稍后再试
     * 3：创建失败
     **/
    private Integer status;

    /**
     * 订单号。创建完成后返回
     **/
    @JsonProperty("order_id")
    private String orderId;

    /**
     * 下单失败的企业及原因。详见FailInfo
     **/
    @JsonProperty("fail_list")
    private List<InvalidInfoDto> failList;
}
