package cn.kinyun.wework.sdk.entity.license.order;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
public class GetUnionOrderResp extends ErrorCode {

    /**
     * 订单id
     **/
    @JsonProperty("order")
    private OrderInfoDto orderInfoDto;

    /**
     * 是否有更多。 0: 没有， 1: 有
     **/
    @JsonProperty("hasMore")
    private Integer hasMore;

    /**
     *分页游标，下次请求时填写到 cursor 以获取之后分页的记录
     **/
    @JsonProperty("next_cursor")
    private String nextCursor;

    /**
     *多企业购买信息列表，详见BuyInfo
     **/
    @JsonProperty("buy_list")
    private List<SubBuyInfoDto> buyList;

}
