package cn.kinyun.wework.sdk.entity.license.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class BuyInfoDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业id
     * 必传
     **/
    @JsonProperty("corpid")
    private String corpId;

    /**
     * 账号个数详情，基础账号跟互通账号不能同时为0
     * 必传
     */
    @JsonProperty("account_count")
    private AccountCountDto accountCountDto;

    /**
     * 帐号购买时长。总购买时长为(months*31+days)天，最少购买1个月(31天)，最多购买60个月(1860天)。若企业为服务商测试企业，只支持购买1个月，不支持指定天购买
     * 必传
     */
    @JsonProperty("account_duration")
    private AccountDurationDto accountDurationDto;

    /**
     * 是否开启自动激活，不填默认开启。
     * 0：关闭 ，1：开启
     **/
    @JsonProperty("auto_active_status")
    private Integer autoActiveStatus;

}
