package cn.kinyun.wework.sdk.entity.license.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.io.Serializable;

@Data
public class AccountDurationDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 购买的月数，每个月按照31天计算
     **/
    @JsonProperty("months")
    private Integer months;

    /**
     * 购买的天数
     **/
    @JsonProperty("days")
    private Integer days;

    /**
     * 指定的新到期时间戳，不可为今天和过去的时间，不可为1860天后的时间。须填当天的24时0分0秒，否则系统自动处理为当天的24时0分0秒。(若企业为服务商测试企业，不支持指定新的到期时间来续期)
     **/
    @JsonProperty("new_expire_time")
    private Long newExpireTime;
}
