package cn.kinyun.wework.sdk.entity.license.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import java.io.Serializable;

@Data
public class ShareInfoDto implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 下游企业corpid。当激活码通过上游分配给下游时，获取上游企业该激活码详情时返回该字段，表示被分配给了哪个下游企业
     **/
    @JsonProperty("to_corpid")
    private String toCorpId;

    /**
     * 上游企业corpid。当激活码通过上游分配给下游时，获取下游企业该激活码详情时返回该字段，表示从哪个上游企业分享过来
     **/
    @JsonProperty("from_corpid")
    private String fromCorpId;
}
