package cn.kinyun.wework.sdk.entity.license.account;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

@Data
public class ListActivatedAccountResp extends ErrorCode {

    /**
     * 分页游标，再下次请求时填写以获取之后分页的记录，如果已经没有更多的数据则返回空
     **/
    @JsonProperty("next_cursor")
    private String nextCursor;

    /**
     * 是否有更多。 0: 没有， 1: 有
     **/
    @JsonProperty("has_more")
    private Integer hasMore;

    /**
     * 已激活成员列表，已激活过期的也会返回
     **/
    @JsonProperty("account_list")
    private List<ActivatedAccountDto> accountList;
}
