package cn.kinyun.wework.sdk.entity.external.statistic;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author sunwen
 */
@Data
public class GroupStatisticData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 新增客户群数量
     */
    @JsonProperty("new_chat_cnt")
    private Integer newChatCnt;

    /**
     * 截至当天客户群总数量
     */
    @JsonProperty("chat_total")
    private Integer chatTotal;

    /**
     * 截至当天有发过消息的客户群数量
     */
    @JsonProperty("chat_has_msg")
    private Integer chatHasMsg;

    /**
     * 客户群新增群人数
     */
    @JsonProperty("new_member_cnt")
    private Integer newMemberCnt;

    /**
     * 截至当天客户群总人数
     */
    @JsonProperty("member_total")
    private Integer memberTotal;

    /**
     * 截至当天有发过消息的群成员数
     */
    @JsonProperty("member_has_msg")
    private Integer memberHasMsg;

    /**
     * 截至当天客户群消息总数
     */
    @JsonProperty("msg_total")
    private Integer msgTotal;

    /**
     * 截至当天新增迁移群数(仅教培行业返回)
     */
    @JsonProperty("migrate_trainee_chat_cnt")
    private Integer migrateTraineeChatCnt;
}
