package cn.kinyun.wework.sdk.entity.external.statistic;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class BehaviorData implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("stat_time")
    private Long statTime;

    /**
     * 聊天总数， 成员有主动发送过消息的单聊总数
     */
    @JsonProperty("chat_cnt")
    private Integer chatCnt;

    /**
     * 发送消息数，成员在单聊中发送的消息总数
     */
    @JsonProperty("message_cnt")
    private Integer messageCnt;

    /**
     * 已回复聊天占比，浮点型
     */
    @JsonProperty("reply_percentage")
    private Float replyPercentage;

    /**
     * 平均首次回复时长，单位为分钟
     */
    @JsonProperty("avg_reply_time")
    private Integer avgReplyTime;

    /**
     * 删除/拉黑成员的客户数
     */
    @JsonProperty("negative_feedback_cnt")
    private Integer negativeFeedbackCnt;

    /**
     * 发起申请数
     */
    @JsonProperty("new_apply_cnt")
    private Integer newApplyCnt;

    /**
     * 新增客户数，成员新添加的客户数量
     */
    @JsonProperty("new_contact_cnt")
    private Integer newContactCnt;
}
