package cn.kinyun.wework.sdk.entity.external.groupchat;


import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

@Data
public class ChatMember implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 群成员id
     */
    @JsonAlias("userid")
    private String userId;

    /**
     * 成员类型。
     * 1 - 企业成员
     * 2 - 外部联系人
     */
    private Integer type;

    /**
     * 外部联系人在微信开放平台的唯一身份标识（微信unionid），通过此字段企业可将外部联系人与公众号/小程序用户关联起来
     */
    @JsonAlias("unionid")
    private String unionId;

    /**
     * 单位是秒
     */
    @JsonAlias("join_time")
    private Long joinTime;

    /**
     * 入群方式。
     * 1 - 由成员邀请入群（直接邀请入群）
     * 2 - 由成员邀请入群（通过邀请链接入群）
     * 3 - 通过扫描群二维码入群
     */
    @JsonAlias("join_scene")
    private Integer joinScene;

    /**
     * 邀请人
     */
    private ChatInvitor invitor;

    /**
     * 在群里的昵称
     */
    @JsonAlias("group_nickname")
    private String groupNickname;

    /**
     * 名字。仅当 need_name = 1 时返回
     * 如果是微信用户，则返回其在微信中设置的名字
     * 如果是企业微信联系人，则返回其设置对外展示的别名或实名
     */
    private String name;
}
