package cn.kinyun.wework.sdk.entity.external.contactway;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 客户联系配置参数
 */
@Data
public class ContactWay implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 配置id 新增时候不需要， 用于显示配置
     * 更新时候必填
     */
    @JsonProperty("config_id")
    private String configId;
    /**
     * 	联系方式类型,1-单人, 2-多人
     * 	必传
     */
    private Integer type;

    /**
     * 场景，1-在小程序中联系，2-通过二维码联系
     * 必传
     */
    private Integer scene;

    /**
     * 在小程序中联系时使用的控件样式
     */
    private Integer style;

    /**
     * 联系方式的备注信息，用于助记，不超过30个字符
     */
    private String remark;

    /**
     * 外部客户添加时是否无需验证，默认为true
     */
    @JsonProperty("skip_verify")
    private boolean skipVerify = true;

    /**
     * 企业自定义的state参数，用于区分不同的添加渠道，在调用“获取外部联系人详情”时会返回该参数值，不超过30个字符
     */
    private String state;

    /**
     * 使用该联系方式的用户userID列表，在type为1时为必填，且只能有一个
     */
    @JsonProperty("user")
    private List<String> userIds;

    /**
     * 使用该联系方式的部门id列表，只在type为2时有效
     */
    @JsonProperty("party")
    private List<Integer> departmentIds;

    /**
     * 是否临时会话模式，true表示使用临时会话模式，默认为false
     */
    @JsonProperty("is_temp")
    private Boolean isTemp;

    /**
     * 临时会话二维码有效期，以秒为单位。该参数仅在is_temp为true时有效，默认7天
     */
    @JsonProperty("expires_in")
    private Integer expiresIn;

    /**
     * 临时会话有效期，以秒为单位。该参数仅在is_temp为true时有效，默认为添加好友后24小时
     */
    @JsonProperty("chat_expires_in")
    private Integer chatExpiresIn;

    /**
     * 可进行临时会话的客户unionid，该参数仅在is_temp为true时有效，如不指定则不进行限制
     */
    @JsonProperty("unionid")
    private String unionId;

    /**
     * 结束语，会话结束时自动发送给客户，可参考“结束语定义”，仅在is_temp为true时有效
     */
    private Conclusions conclusions;
}
