/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title Meeting
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class Meeting implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 会议主题。String类型
     */
    private String topic;

    /**
     * 会议开始时间。Utc时间
     */
    @JsonAlias("starttime")
    private Long startTime;

    /**
     * 会议结束时间。Utc时间
     */
    @JsonAlias("endtime")
    private Long endTime;

    /**
     * 会议地址。String类型
     */
    private String address;

    /**
     * 会议备注。String类型
     */
    private String remarks;

    /**
     * 会议消息类型。101发起会议邀请消息、102处理会议邀请消息。Uint32类型
     */
    @JsonAlias("meetingtype")
    private Integer meetingType;

    /**
     * 会议id。方便将发起、处理消息进行对照。uint64类型
     */
    @JsonAlias("meetingid")
    private Long meetingId;

    /**
     * 会议邀请处理状态。1 参加会议、2 拒绝会议、3 待定、4 未被邀请、5 会议已取消、6 会议已过期、7 不在房间内。Uint32类型。只有meetingtype为102的时候此字段才有内容。
     */
    private Integer status;
}