/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;

import lombok.Data;

/**
 * @title Card
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 */
@Data
public class Card implements Serializable {
    
    private static final long serialVersionUID = 1L;

    /**
     * 名片所有者所在的公司名称。String类型
     */
    @JsonAlias("corpname")
    private String corpName;

    /**
     * 名片所有者的id，同一公司是userid，不同公司是external_userid。String类型
     */
    @JsonAlias("userid")
    private String userId;
}