package cn.kinyun.wework.sdk.entity.agent;

import cn.kinyun.wework.sdk.entity.agent.msg.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Data;

@JsonTypeInfo(
        use = JsonTypeInfo.Id.NAME,
        property = "msgtype")
@JsonSubTypes({
        @JsonSubTypes.Type(value = FileMsg.class, name = "file"),
        @JsonSubTypes.Type(value = ImageMsg.class, name = "image"),
        @JsonSubTypes.Type(value = MarkdownMsg.class, name = "markdown"),
        @JsonSubTypes.Type(value = MiniProgramMsg.class, name = "miniprogram_notice"),
        @JsonSubTypes.Type(value = MpNewMsg.class, name = "mpnews"),
        @JsonSubTypes.Type(value = NewsMsg.class, name = "news"),
        @JsonSubTypes.Type(value = TaskCardMsg.class, name = "taskcard"),
        @JsonSubTypes.Type(value = TextCardMsg.class, name = "textcard"),
        @JsonSubTypes.Type(value = TextMsg.class, name = "text"),
        @JsonSubTypes.Type(value = VideoMsg.class, name = "video"),
        @JsonSubTypes.Type(value = VoiceMsg.class, name = "voice"),
})
@Data
public abstract class AgentMsgBase implements Serializable {
    private static final long serialVersionUID = 1L;

    @JsonProperty("touser")
    private String toUser;

    @JsonProperty("toparty")
    private String toParty;

    @JsonProperty("totag")
    private String toTag;

    /**
     * 消息类型
     */
    @JsonProperty("msgtype")
    private String msgType;

    @JsonProperty("agentid")
    private Integer agentId;

    /**
     * 表示是否是保密消息
     * 
     * 0表示可对外分享;
     * 1表示不能分享且内容显示水印;
     * 2表示仅限在企业内分享，默认为0;
     * 
     * 注意仅mpnews类型的消息支持safe值为2，其他消息类型不支持
     */
    private Integer safe;

    /**
     * 表示是否开启id转译，0表示否，1表示是，默认0
     * 
     * <pre>
     * 1.支持的消息类型和对应的字段
     * 
     * 文本（text）：content
     * 文本卡片（textcard）：title、description
     * 图文（news）：title、description
     * 图文（news）：title、description
     * 图文（mpnews）：title、digest、content
     * 任务卡片（taskcard）：title、description
     * 小程序通知（miniprogram_notice）：title、description、content_item.value
     * 
     * 2.id转译模版语法
     * 
     * $departmentName=DEPARTMENT_ID$
     * $userName=USERID$
     * 
     * 其中 DEPARTMENT_ID 是数字类型的部门id，USERID 是成员帐号。
     * 
     * 譬如，
     * 将$departmentName=1$替换成部门id为“1”对应的部门名，如“企业微信产品部”；
     * 将$userName=lisi007$替换成userid为“lisi007”对应的用户名，如“李四”；
     * </pre>
     * 
     * @link https://open.work.weixin.qq.com/api/doc/90000/90135/90236#%E6%8E%A5%E5%8F%A3%E5%AE%9A%E4%B9%89
     */
    @JsonProperty("enable_id_trans")
    private Integer enableIdTrans;

    /**
     * 表示是否开启重复消息检查，0表示否，1表示是，默认0
     */
    @JsonProperty("enable_duplicate_check")
    private Integer enableDuplicateCheck;

    /**
     * 表示是否重复消息检查的时间间隔，默认1800s，最大不超过4小时
     */
    @JsonProperty("duplicate_check_interval")
    private Integer duplicateCheckInterval;
}
