package cn.kinyun.wework.sdk.entity.agent;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper= true)
public class Agent extends ErrorCode {
    private static final long serialVersionUID = 1L;

    @JsonAlias("agentid")
    private Integer agentId;

    private String name;

    /**
     * 企业应用方形头像
     */
    @JsonAlias("square_logo_url")
    private String squareLogoUrl;

    private String description;

    /**
     * 企业应用可见范围（人员），其中包括userid
     */
    @JsonAlias("allow_userinfos")
    private AllowUserInfos allowUserInfos;

    /**
     * 企业应用可见范围（部门）
     */
    @JsonAlias("allow_partys")
    private AllowPartys allowPartys;

    /**
     * 企业应用可见范围（标签）
     */
    @JsonAlias("allow_tags")
    private AllowTags allowTags;

    /**
     * 企业应用是否被停用 0否  1是
     */
    private Integer close;

    /**
     * 企业应用可信域名
     */
    @JsonAlias("redirect_domain")
    private String redirectDomain;

    /**
     * 企业应用是否打开地理位置上报 0：不上报；1：进入会话上报；
     */
    @JsonAlias("report_location_flag")
    private Integer reportLocationFlag;

    /**
     * 是否上报用户进入应用事件。0：不接收；1：接收
     */
    @JsonAlias("isreportenter")
    private Integer isReportEnter;

    /**
     * 应用主页url
     */
    @JsonAlias("home_url")
    private String homeUrl;
}
