package cn.kinyun.wework.sdk.callback.suite.external;


import cn.kinyun.wework.sdk.callback.suite.BaseSuiteEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 删除跟进成员事件
 * 
 * ChangeType: del_follow_user
 * 
 * @title DelFollowUser
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/92277
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DelFollowUser extends BaseSuiteEvent {

    private static final long serialVersionUID = 1L;

    /**
     * 企业服务人员的UserID
     */
    @JacksonXmlProperty(localName = "UserID")
    private String userId;

    /**
     * 外部联系人的userid，注意不是企业成员的帐号
     */
    @JacksonXmlProperty(localName = "ExternalUserID")
    private String externalUserId;
}
