package cn.kinyun.wework.sdk.callback.suite.auth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

import java.io.Serializable;

/**
 * 重置永久授权码通知
 *
 * <p>在服务商管理端的代开发应用详情页，点击“重新获取secret”会触发该事件的回调，服务商收到回调事件后，可使用AuthCode通过获取企业永久授权码接口获取代开发应用最新的secret（即permanent_code字段）。</p>
 *
 * @author yanmaoyuan
 * @date 2022/1/17
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class ResetPermanentCode implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 代开发自建应用的SuiteId
     */
    @JacksonXmlProperty(localName = "SuiteId")
    private String suiteId;

    /**
     * 临时授权码,最长为512字节。用于获取企业永久授权码。10分钟内有效
     */
    @JacksonXmlProperty(localName = "AuthCode")
    private String authCode;

    /**
     * 消息类型 reset_permanent_code
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

}
