/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.suite.auth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 授权成功通知
 * 
 * <p>从企业微信应用市场发起授权时，企业微信后台会推送授权成功通知。</p>
 * <p>从第三方服务商网站发起的应用授权流程，由于授权完成时会跳转第三方服务商管理后台，因此不会通过此接口向第三方服务商推送授权成功通知。</p>
 * 
 * @title CreateAuth
 * @author yanmaoyuan
 * @date 2021年2月19日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class CreateAuth implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * 第三方应用的SuiteId
     */
    @JacksonXmlProperty(localName = "SuiteId")
    private String suiteId;

    /**
     * 消息类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    /**
     * 授权的auth_code,最长为512字节。用于获取企业的永久授权码。10分钟内有效
     */
    @JacksonXmlProperty(localName = "AuthCode")
    private String authCode;

    /**
     * 构造授权链接指定的state参数
     */
    @JacksonXmlProperty(localName = "State")
    private String state;
}
