package cn.kinyun.wework.sdk.callback.suite;


import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 通讯录成员事件回调对应的基本类
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class BaseSuiteEvent implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 第三方应用ID
     */
    @JacksonXmlProperty(localName = "SuiteId")
    private String suiteId;

    /**
     * 授权给第三方应用的企业ID
     */
    @JacksonXmlProperty(localName = "AuthCorpId")
    private String authCorpId;
    
    /**
     * 信息类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    /**
     * 
     */
    @JacksonXmlProperty(localName = "ChangeType")
    private String changeType;
}
