package cn.kinyun.wework.sdk.callback.license;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import lombok.Data;

import java.io.Serializable;

/**
 * @author: lwl
 * @date: 2023/5/18
 * @description: 接口许可失效通知
 *
 * @link: https://developer.work.weixin.qq.com/document/path/95994
 **/
@Data
@JacksonXmlRootElement(localName = "xml")
public class AutoActiveEvent implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 服务商CorpID
     */
    @JacksonXmlProperty(localName = "ServiceCorpId")
    private String serviceCorpId;

    /**
     * 事件类型，此时固定为auto_activate
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 客户企业CorpID
     */
    @JacksonXmlProperty(localName = "AuthCorpId")
    private String authCorpId;

    /**
     * 许可自动激活的时机，1:企业成员主动访问应用，2:服务商调用消息推送接口，3:服务商调用互通接口
     */
    @JacksonXmlProperty(localName = "Scene")
    private Integer scene;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timeStamp;

    /**
     * 激活的许可帐号列表
     */
    @JacksonXmlProperty(localName = "AccountList")
    private AccountList accountList;

    @Data
    public static class AccountList implements Serializable{
        private static final long serialVersionUID = 1L;

        /**
         * 自动激活的许可帐号激活码
         */
        @JacksonXmlProperty(localName = "ActiveCode")
        private String activeCode;

        /**
         * 自动激活的许可的类型，1:基础许可，2:互通许可
         */
        @JacksonXmlProperty(localName = "Type")
        private Integer type;

        /**
         * 自动激活的许可帐号激活码
         */
        @JacksonXmlProperty(localName = "ExpireTime")
        private Long expireTime;

        /**
         * 许可自动激活的成员的UserID
         */
        @JacksonXmlProperty(localName = "UserId")
        private String userId;

        /**
         * 激活成员自动激活前的许可状态，1:未激活许可，2:已激活许可且许可未过期（即许可的剩余时长小于等于7天），3:已激活许可且许可已过期
         */
        @JacksonXmlProperty(localName = "PreviousStatus")
        private Integer previousStatus;

        /**
         * 仅针对已激活的成员进行自动激活时返回，返回该成员之前激活的旧的激活码
         */
        @JacksonXmlProperty(localName = "PreviousActiveCode")
        private String previousActiveCode;

    }
}
