package cn.kinyun.wework.sdk.callback.corp.external;


import cn.kinyun.wework.sdk.callback.corp.BaseCorpEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 企业客户标签创建事件
 * ChangeType: create
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class CreateExternalTag extends BaseCorpEvent {
    private static final long serialVersionUID = 1L;

    /**
     * 标签或标签组的ID
     */
    @JacksonXmlProperty(localName = "Id")
    private String id;

    /**
     * 创建标签时，此项为tag，创建标签组时，此项为tag_group
     */
    @JacksonXmlProperty(localName = "TagType")
    private String tagType;
}
