package cn.kinyun.wework.sdk.callback.corp.contact;


import cn.kinyun.wework.sdk.callback.corp.BaseCorpEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 
 * @title UpdateUser
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90000/90135/90970
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class UpdateUser extends BaseCorpEvent {
    private static final long serialVersionUID = 1L;

    /**
     * 	成员UserID
     */
    @JacksonXmlProperty(localName = "UserID")
    private String userId;

    @JacksonXmlProperty(localName = "NewUserID")
    private String newUserID;

    /**
     * 成员名字
     */
    @JacksonXmlProperty(localName = "Name")
    private String name;

    /**
     * 成员部门列表，仅返回该应用有查看权限的部门id
     */
    @JacksonXmlProperty(localName = "Department")
    private String department;

    /**
     * 主部门
     */
    @JacksonXmlProperty(localName = "MainDepartment")
    private String mainDepartment;

    /**
     * 表示所在部门是否为上级，0-否，1-是，顺序与Department字段的部门逐一对应
     */
    @JacksonXmlProperty(localName = "IsLeaderInDept")
    private String isLeaderInDept;

    /**
     * 职位信息。长度为0~64个字节
     */
    @JacksonXmlProperty(localName = "Position")
    private String position;

    /**
     * 手机号码
     */
    @JacksonXmlProperty(localName = "Mobile")
    private String mobile;

    /**
     * 性别，1表示男性，2表示女性
     */
    @JacksonXmlProperty(localName = "Gender")
    private Integer gender;

    @JacksonXmlProperty(localName = "Email")
    private String email;

    /**
     * 激活状态：1=已激活 2=已禁用 4=未激活 已激活代表已激活企业微信或已关注微工作台（原企业号）5=成员退出
     */
    @JacksonXmlProperty(localName = "Status")
    private Integer status;

    /**
     * 头像url。注：如果要获取小图将url最后的”/0”改成”/100”即可。
     */
    @JacksonXmlProperty(localName = "Avatar")
    private String avatar;

    @JacksonXmlProperty(localName = "Alias")
    private String alias;

    /**
     * 座机
     */
    @JacksonXmlProperty(localName = "Telephone")
    private String telephone;

    @JacksonXmlProperty(localName = "Address")
    private String address;

    /**
     * 扩展属性
     */
    @JacksonXmlProperty(localName = "ExtAttr")
    List<ExtAttrItem> extAttr;
}
