package cn.kinyun.wework.sdk.callback.corp.contact;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

@Data
@JacksonXmlRootElement(localName = "Item")
public class ExtAttrItem implements Serializable {
    private static final long serialVersionUID = 1L;

    @JacksonXmlProperty(localName = "Name")
    private String name;

    @JacksonXmlProperty(localName = "Type")
    private Integer type;

    @JacksonXmlProperty(localName = "Text")
    private Text text;

    @JacksonXmlProperty(localName = "Web")
    private Web web;

    @Data
    public static class Text implements Serializable {
        private static final long serialVersionUID = 1L;

        @JacksonXmlProperty(localName = "Value")
        private String value;
    }

    @Data
    public static class Web implements Serializable {
        private static final long serialVersionUID = 1L;

        @JacksonXmlProperty(localName = "Title")
        private String title;

        @JacksonXmlProperty(localName = "Url")
        private String url;
    }

}
