package cn.kinyun.wework.sdk.callback.corp;


import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * 通讯录成员事件回调对应的基本类
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class BaseCorpEvent implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业微信CorpID
     */
    @JacksonXmlProperty(localName = "ToUserName")
    private String toUserName;

    /**
     * 此事件该值固定为sys，表示该消息由系统生成
     */
    @JacksonXmlProperty(localName = "FromUserName")
    private String fromUserName;

    /**
     * 消息创建时间
     */
    @JacksonXmlProperty(localName = "CreateTime")
    private Long createTime;

    /**
     * 消息的类型，此时固定为event
     */
    @JacksonXmlProperty(localName = "MsgType")
    private String msgType;

    /**
     * 事件的类型，此时固定为change_contact
     */
    @JacksonXmlProperty(localName = "Event")
    private String event;

    @JacksonXmlProperty(localName = "ChangeType")
    private String changeType;
}
