package cn.kinyun.wework.sdk.callback.agent.msg;


import cn.kinyun.wework.sdk.callback.agent.BaseAgentMsg;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 链接消息
 * msgType link
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class LinkMsg extends BaseAgentMsg {
    private static final long serialVersionUID = 1L;

    @JacksonXmlProperty(localName = "Title")
    private String title;

    @JacksonXmlProperty(localName = "Description")
    private String description;

    /**
     * 	链接跳转的url
     */
    @JacksonXmlProperty(localName = "Url")
    private String url;

    /**
     * 封面缩略图的url
     */
    @JacksonXmlProperty(localName = "PicUrl")
    private String picUrl;

}
