/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.wework.sdk.exception;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import java.util.ResourceBundle;
import lombok.NonNull;

public class WeworkException
extends RuntimeException {
    private static final long serialVersionUID = 3738216579645492071L;
    private static final String MESSAGE_FORMAT = "error(%d):%s";
    private static final String DEFAULT_ERROR_MESSAGE = "\u8bf7\u6c42\u5fae\u4fe1\u63a5\u53e3\u5931\u8d25\uff0c\u672a\u77e5\u9519\u8bef\u3002";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("message.WeworkErrorCode");
    private final Integer errorCode;
    private final String errorMsg;
    private final String hint;

    public WeworkException(Integer errorCode, String errorMsg, String hint) {
        super(String.format(MESSAGE_FORMAT, errorCode, errorMsg));
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.hint = hint;
    }

    public String getHint() {
        return this.hint;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public static String getErrorMsg(Integer errorCode) {
        try {
            return RESOURCE_BUNDLE.getString(String.valueOf(errorCode));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isSuccess(@NonNull Integer errorCode) throws WeworkException {
        if (errorCode == null) {
            throw new NullPointerException("errorCode is marked non-null but is null");
        }
        return WeworkException.isSuccess(errorCode, DEFAULT_ERROR_MESSAGE);
    }

    public static boolean isSuccess(@NonNull ErrorCode error) throws WeworkException {
        if (error == null) {
            throw new NullPointerException("error is marked non-null but is null");
        }
        return WeworkException.isSuccess(error.getErrCode(), error.getErrMsg());
    }

    public static boolean isSuccess(Integer errorCode, String originErrorMsg) throws WeworkException {
        if (errorCode == null || errorCode == 0) {
            return true;
        }
        String errorMsg = WeworkException.getErrorMsg(errorCode);
        if (errorMsg == null) {
            errorMsg = originErrorMsg != null ? originErrorMsg : DEFAULT_ERROR_MESSAGE;
        }
        throw new WeworkException(errorCode, errorMsg, originErrorMsg);
    }
}

