/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title AuthInfo
 * @author yanmaoyuan
 * @date 2021年2月24日
 * @version 1.0
 * @see https://open.work.weixin.qq.com/api/doc/90001/90143/90604
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class AuthInfo extends ErrorCode {

    private static final long serialVersionUID = 1L;

    @JsonAlias("dealer_corp_info")
    private DealerCorpInfo dealerCorpInfo;

    @JsonAlias("auth_corp_info")
    private AuthCorpInfo authCorpInfo;

    @JsonAlias("auth_info")
    private AuthAgentInfo authInfo;

}
