/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.oauth2;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title Userdetail3rd
 * @author yanmaoyuan
 * @date 2021年2月26日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class Userdetail3rd extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 用户所属企业的corpid
     */
    @JsonAlias("corpid")
    private String corpId;

    /**
     * 成员UserID
     */
    @JsonAlias("userid")
    private String userId;

    /**
     * 成员姓名，此字段从2019年12月30日起，对新创建第三方应用不再返回真实name，使用userid代替name返回，2020年6月30日起，对所有历史第三方应用不再返回，第三方页面需要通过通讯录展示组件来展示名字
     * @see https://open.work.weixin.qq.com/api/doc/90001/90143/91122
     * @see https://open.work.weixin.qq.com/api/doc/90001/90143/91958
     */
    private String name;

    /**
     * 性别。0表示未定义，1表示男性，2表示女性
     */
    private String gender;

    private String avatar;

    @JsonAlias("qr_code")
    private String qrCode;
}
