package cn.kinyun.wework.sdk.entity.license.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class CreateRenewOrderJobReq implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业Id
     * 必传
     **/
    @JsonProperty("corpid")
    private String corpId;

    /**
     * 续期的帐号列表，每次最多1000个。同一个jobid最多关联1000000个基础账号跟1000000个互通账号
     * 必传
     **/
    @JsonProperty("account_list")
    private List<AccountUserDto> accountList;

    /**
     * 任务id，若不传则默认创建一个新任务。若指定第一次调用后拿到jobid，可以通过该接口将jobid关联多个userid
     **/
    @JsonProperty("jobid")
    private String jobId;
}
