package cn.kinyun.wework.sdk.entity.license.order;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class CreateNewOrderJobReq implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业新购信息列表，详见BuyInfo。每次最多传10个，每个jobid最多关联100000个BuyInfo
     * 必传
     **/
    @JsonProperty("buy_list")
    private List<BuyInfoDto> buyList;

    /**
     * 多企业新购任务id：
     * 不传：默认创建一个新任务。
     * 有传：必须为第一次调用后返回的jobid，可以通过该接口将该任务关联多个新企业的购买账号信息
     **/
    @JsonProperty("job_id")
    private String jobId;

}
