package cn.kinyun.wework.sdk.entity.external.transfer;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

@Data
public class TransferCustomerParams implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 原跟进成员的userid
     * 必传
     */
    @JsonProperty("handover_userid")
    private String handoverUserId;

    /**
     * 接替成员的userid
     * 必传
     */
    @JsonProperty("takeover_userid")
    private String takeoverUserId;

    /**
     * 客户的external_userid列表，每次最多分配100个客户
     * 必传
     */
    @JsonProperty("external_userid")
    private List<String> externalUserIdList;

    /**
     * 转移成功后发给客户的消息，最多200个字符，不填则使用默认文案
     */
    @JsonProperty("transfer_success_msg")
    private String transferSuccessMsg;
}
