package cn.kinyun.wework.sdk.entity.external.statistic;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author sunwen
 */
@Data
public class GroupChatStatisticParam implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 起始日期的时间戳，填当天的0时0分0秒（否则系统自动处理为当天的0分0秒）。取值范围：昨天至前180天
     */
    @JsonProperty("day_begin_time")
    private Long dayBeginTime;

    /**
     * 结束日期的时间戳，填当天的0时0分0秒（否则系统自动处理为当天的0分0秒）。取值范围：昨天至前180天。
     * 如果不填，默认同 day_begin_time（即默认取一天的数据）
     */
    @JsonProperty("day_end_time")
    private Long dayEndTime;

    /**
     * 群主过滤。
     * 如果不填，表示获取应用可见范围内全部群主的数据（但是不建议这么用，如果可见范围人数超过1000人，为了防止数据包过大，会报错 81017）
     */
    @JsonProperty("owner_filter")
    private OwnerFilterParam ownerFilter;

    @JsonProperty("order_by")
    private Integer orderBy;

    @JsonProperty("order_asc")
    private Integer orderAsc;

    private Integer offset;

    private Integer limit;
}
