package cn.kinyun.wework.sdk.entity.external.msg;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;

import lombok.Data;

@Data
public class MiniProgram implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 小程序消息标题
     * 必须
     */
    private String title;

    /**
     * 小程序消息封面的mediaid
     * 必须
     */
    @JsonProperty("pic_media_id")
    private String picMediaId;

    /**
     * 小程序appid，必须是关联到企业的小程序应用
     * 必须
     */
    @JsonProperty("appid")
    private String appId;

    /**
     * 小程序page路径
     * 必须
     */
    private String page;
}
