package cn.kinyun.wework.sdk.entity.external.customeracquisition;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

import java.io.Serializable;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2023/5/6
 */
@Data
public class CustomerAcquisitionContact implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonAlias("external_userid")
    private String externalUserId;// 客户external_userid
    @JsonAlias("userid")
    private String userId;// 通过获客链接添加此客户的跟进人userid
    @JsonAlias("chat_status")
    private Integer chatStatus;// 会话状态，0-客户未发消息 1-客户已发送消息
    // 用于区分客户具体是通过哪个获客链接进行添加，用户可在获客链接后拼接customer_channel=自定义字符串，字符串不超过64字节，超过会被截断。
    // 通过点击带有customer_channel参数的链接获取到的客户，调用获客信息接口或获取客户详情接口时，返回的state参数即为链接后拼接自定义字符串
    private String state;
}
