package cn.kinyun.wework.sdk.entity.contact.user;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 成员的信息
 */
@Data
public class UserSimpleInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 成员id
     */
    @JsonAlias("userid")
    private String userId;

    /**
     * 成员名
     */
    private String name;

    /**
     * 所属部门列表
     */
    @JsonAlias("department")
    private List<Integer> department;

    /**
     * 全局唯一。对于同一个服务商，不同应用获取到企业内同一个成员的open_userid是相同的，最多64个字节。仅第三方应用可获取
     */
    @JsonAlias("open_userid")
    private String openUserId;

}

