/**
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.chat.msg;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @title Calendar
 * @author yanmaoyuan
 * @date 2021年3月22日
 * @version 1.0
 */
@Data
public class Calendar implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 日程主题。String类型
     */
    private String title;

    /**
     * 日程组织者。String类型
     */
    @JsonAlias("creatorname")
    private String creatorName;

    /**
     * 日程参与人。数组，内容为String类型
     */
    @JsonAlias("attendeename")
    private List<String> attendeeName;

    /**
     * 日程开始时间。Utc时间，单位秒
     */
    @JsonAlias("starttime")
    private Long startTime;

    /**
     * 日程结束时间。Utc时间，单位秒
     */
    @JsonAlias("endTime")
    private Long endtime;

    /**
     * 日程地点。String类型
     */
    private String place;

    /**
     * 日程备注。String类型
     */
    private String remarks;
}
