package cn.kinyun.wework.sdk.entity;

import com.fasterxml.jackson.annotation.JsonProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 临时票据，用于jsapi
 * 
 * @title Ticket
 * @author yanmaoyuan
 * @date 2021年3月31日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class Ticket extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 票据
     */
    private String ticket;

    /**
     * 有效期，默认7200秒
     */
    @JsonProperty("expires_in")
    private int expires = 7200;
}
