package cn.kinyun.wework.sdk.callback.suite.contact;

import cn.kinyun.wework.sdk.callback.suite.BaseSuiteEvent;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 删除部门事件
 * 
 * ChangeType   固定为delete_party
 * 
 * @title DeleteParty
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 * @see https://work.weixin.qq.com/api/doc/90001/90143/92655
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class DeleteParty extends BaseSuiteEvent {

    private static final long serialVersionUID = 1L;

    /**
     * 部门Id
     */
    @JacksonXmlProperty(localName = "Id")
    private Integer id;
}
