/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.suite.auth;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import java.io.Serializable;

import lombok.Data;

/**
 * 取消授权通知
 * 
 * <p>当授权方（即授权企业）在企业微信管理端的授权管理中，取消了对应用的授权托管后，企业微信后台会推送取消授权通知。</p>
 * <p>注意，服务商收到取消授权事件后，应当确保删除该企业所有相关的数据。</p>
 * 
 * @title CancelAuth
 * @author yanmaoyuan
 * @date 2021年2月19日
 * @version 1.0
 */
@Data
public class CancelAuth implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 第三方应用的SuiteId
     */
    @JacksonXmlProperty(localName = "SuiteId")
    private String suiteId;

    /**
     * 消息类型
     */
    @JacksonXmlProperty(localName = "InfoType")
    private String infoType;

    /**
     * 时间戳
     */
    @JacksonXmlProperty(localName = "TimeStamp")
    private Long timestamp;

    /**
     * 授权方的corpid
     */
    @JacksonXmlProperty(localName = "AuthCorpId")
    private String authCorpId;

}
