package cn.kinyun.wework.sdk.callback.agent.msg;

import cn.kinyun.wework.sdk.callback.agent.BaseAgentMsg;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 视频消息
 * msgType video
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class VideoMsg extends BaseAgentMsg {
    private static final long serialVersionUID = 1L;

    /**
     * 视频媒体文件id，可以调用获取媒体文件接口拉取数据，仅三天内有效
     */
    @JacksonXmlProperty(localName = "MediaId")
    private String mediaId;

    /**
     * 视频消息缩略图的媒体id，可以调用获取媒体文件接口拉取数据，仅三天内有效
     */
    @JacksonXmlProperty(localName = "ThumbMediaId")
    private String thumbMediaId;

}
