/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.callback.agent;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

import java.io.Serializable;

import lombok.Data;

/**
 * @title BaseAgentEvent
 * @author yanmaoyuan
 * @date 2021年4月26日
 * @version 1.0
 */
@Data
@JacksonXmlRootElement(localName = "xml")
public class BaseAgentEvent implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 企业微信CorpID
     */
    @JacksonXmlProperty(localName = "ToUserName")
    private String toUserName;

    /**
     * 成员UserID
     */
    @JacksonXmlProperty(localName = "FromUserName")
    private String fromUserName;

    /**
     * 消息创建时间（整型）
     */
    @JacksonXmlProperty(localName = "CreateTime")
    private Long createTime;

    /**
     * 消息的类型
     */
    @JacksonXmlProperty(localName = "MsgType")
    private String msgType;

    /**
     * 事件的类型
     */
    @JacksonXmlProperty(localName = "Event")
    private String event;

    /**
     * 事件KEY值
     */
    @JacksonXmlProperty(localName = "EventKey")
    private String eventKey;

    /**
     * 企业应用的id，整型。可在应用的设置页面查看
     */
    @JacksonXmlProperty(localName = "AgentID")
    private Integer agentId;
}
