/*
 * kuaikeguanjia.com Inc. Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 通过会话存档拉去的聊天记录，包含如下的消息类型。
 * 
 * @title ChatMsgType
 * @author yanmaoyuan
 * @date 2021年3月18日
 * @version 1.0
 * @link https://work.weixin.qq.com/api/doc/90000/90135/91774
 */
public enum ChatMsgType {

    TEXT("text", "文本"),
    IMAGE("image", "图片"),
    REVOKE("revoke", "撤回消息"),
    AGREE("agree", "同意存档会话内容"),
    DISAGREE("disagree", "不同意存档会话内容"),
    
    VOICE("voice", "语音"),
    VIDEO("video", "视频"),
    CARD("card", "名片"),
    LOCATION("location", "位置"),
    EMOTION("emotion", "表情"),
    
    FILE("file", "文件"),
    LINK("link", "链接"),
    WEAPP("weapp", "小程序消息"),
    CHATRECORD("chatrecord", "会话记录消息"),
    TODO("todo", "待办消息"),// NOSONAR
    VOTE("vote", "投票消息"),
    
    COLLECT("collect", "填表消息"),
    REDPACKET("redpacket", "红包消息"),
    MEETING("meeting", "会议邀请消息"),
    SWITCH("switch", "切换企业日志"),
    DOCMSG("docmsg", "在线文档消息"),
    MARKDOWN("", "MarkDown格式消息"),// 目前为机器人发出的消息

    NEWS("news", "图文消息"),
    CALENDAR("calendar", "日程消息"),
    MIXED("mixed", "混合消息"),
    MEETING_VOICE_CALL("meeting_voice_call", "音频存档消息"),
    VOIP_DOC_SHARE("voip_doc_share", "音频共享文档消息"),
    EXTERNAL_REDPACKET("external_redpacket", "互通红包消息"),
    SPHFEED("sphfeed", "视频号消息"),
    VOIPTEXT("voiptext", "音视频通话"),
    QYDISKFILE("qydiskfile", "微盘文件");


    private final String value;
    private final String desc;

    ChatMsgType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ChatMsgType> CACHE = Arrays.stream(values())
            .collect(Collectors.toMap(ChatMsgType::getValue, Function.identity()));

    public static ChatMsgType getType(String value) {
        return CACHE.get(value);
    }
}
