/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2021 All Rights Reserved.
 */
package cn.kinyun.wework.sdk.entity.suite;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @title ProviderToken
 * @author yanmaoyuan
 * @date 2021年2月24日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper= true)
public class CorpToken extends ErrorCode {

    private static final long serialVersionUID = 1L;

    /**
     * 授权方（企业）access_token,最长为512字节
     */
    @JsonAlias("access_token")
    private String accessToken;

    /**
     * 授权方（企业）access_token超时时间
     */
    @JsonAlias("expires_in")
    private Long expires;

}
