package cn.kinyun.wework.sdk.entity.oauth2;

import com.fasterxml.jackson.annotation.JsonAlias;
import cn.kinyun.wework.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 企业内部应用获取用户身份信息
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class Userinfo extends ErrorCode {
    /**
     * 成员UserID
     */
    @JsonAlias("UserId")
    private String userId;

    /**
     * 手机设备号(由企业微信在安装时随机生成，删除重装会改变，升级不受影响)
     */
    @JsonAlias("DeviceId")
    private String deviceId;

    @JsonAlias("user_ticket")
    private String userTicket;

    /**
     * 非企业成员的标识，对当前企业唯一。不超过64字节
     */
    @JsonAlias("OpenId")
    private String openId;

    /**
     * 外部联系人id，当且仅当用户是企业的客户，且跟进人在应用的可见范围内时返回
     */
    @JsonAlias("external_userid")
    private String externalUserId;
}
