package cn.kinyun.wework.sdk.entity.license.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class BatchShareActiveCodeReq implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 上游企业corpid
     **/
    @JsonProperty("from_corpid")
    private String fromCorpId;

    /**
     * 下游企业corpid
     **/
    @JsonProperty("to_corpid")
    private String toCorpId;

    /**
     * 分享的接口许可列表。单次分享激活码不可超过1000个，累计分享给同一下游企业的激活码总数不可超过上下游通讯录中该下游企业人数的2倍
     **/
    @JsonProperty("share_list")
    private List<ActiveCodeDto> shareList;
}
