package cn.kinyun.wework.sdk.entity.externalpay;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 对外收款记录
 */
@Data
public class BillListInfo implements Serializable {

    @JsonProperty("transaction_id")
    private String transactionId;

    @JsonProperty("trade_state")
    private Integer tradeState;

    @JsonProperty("pay_time")
    private Date payTime;

    @JsonProperty("out_trade_no")
    private String outTradeNo;

    @JsonProperty("external_userid")
    private String externalUserid;

    @JsonProperty("total_fee")
    private Long totalFee;

    @JsonProperty("payee_userid")
    private String payeeUserid;

    @JsonProperty("payment_type")
    private Integer paymentType;

    @JsonProperty("mch_id")
    private String mchId;

    private String remark;

    @JsonProperty("commodity_list")
    private List<CommodityList> commodityList;

    private String commodityListStr;

    @JsonProperty("total_refund_fee")
    private Long totalRefundFee;

    @JsonProperty("refund_list")
    private List<RefundList> refundList;

    private String refundListStr;

    @JsonProperty("payer_info")
    private PayerInfo payerInfo;

    private String payerInfoStr;

    private String cursor;

    private String nextCursor;

    private Date createTime;

    private Long bizId;

    private String corpId;

    private String requestId;
}
