package cn.kinyun.wework.sdk.entity.external.transfer;

import cn.kinyun.wework.sdk.entity.ErrorCode;
import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

@Data
@EqualsAndHashCode(callSuper=true)
public class TransferCustomerResp extends ErrorCode {

    private static final long serialVersionUID = 1L;

    @JsonAlias("customer")
    private List<Customer> customer;

    @Data
    public static class Customer implements Serializable {

        private static final long serialVersionUID = -1524845357232107581L;

        @JsonAlias("external_userid")
        private String externalUserId;

        @JsonAlias("errcode")
        private String errCode;
    }
}